var cssClass  = '.range-slider { width:90%; height:.1rem; margin: 0 auto; position:relative; margin-top: 1.5rem; }'
  +'.range-slider:before { content:""; display:block; position:absolute; left:0; width:100%; height:.1rem; background-color:white; z-index: 999;}'
  +'.range-slider .big-dragger { display:block; height:inherit; z-index:30; background-color: rgba(0, 0, 0, 0); border-radius: 100%; position: absolute; width: 4rem; height: 4rem; margin-top: -2rem; padding-top: 1rem; }'
  +'.range-slider .big-dragger .little-dragger { background: #271206; border: 1px solid white; margin: 0 auto; border-radius: 100%; width: 2rem; height: 2rem; }'
  +'.little-dragger span { color:orange; margin: 0 auto; }';

var EVENT_MOVE = 'touchmove';
var EVENT_START = 'touchstart';
var EVENT_RELEASE = 'touchend';

if('ontouchstart' in window) {
  EVENT_MOVE = 'touchmove';
  EVENT_START = 'touchstart';
  EVENT_RELEASE = 'touchend';
} else if (window.navigator.pointerEnabled) {
  EVENT_MOVE = 'pointermove';
  EVENT_START = 'pointerdown';
  EVENT_RELEASE = 'pointerup';
} else if (window.navigator.msPointerEnabled) {
  EVENT_MOVE = 'MSPointerMove';
  EVENT_START = 'MSPointerDown';
  EVENT_RELEASE = 'MSPointerUp';
} else {
  EVENT_MOVE = 'mousemove';
  EVENT_START = 'mousedown';
  EVENT_RELEASE = 'mouseup';
}

/////////////////////////////// slider ///////////////////////////////

var publishBrightness;
var minimum;
var maximum;
var channel;
var enableScroll;
var disableScroll;

var isMobile = {
  iOS: function() {
      return navigator.userAgent.match(/iPhone|iPad|iPod/i);
  }
};

function lightSlider(publishCallback, min, max, channell, enableScrollFc, disableScrollFc){
  publishBrightness = publishCallback;
  minimum = min;
  maximum = max;
  channel = channell;
  enableScroll = enableScrollFc;
  disableScroll = disableScrollFc;
}

lightSlider.prototype.updateMinMax = function(min, max){
  minimum = min;
  maximum = max;
}

lightSlider.prototype.disableSlider = function(id){
  document.getElementById("bigdragger-"+id).removeEventListener(EVENT_START, startDrag, false);
  document.getElementById("bigdragger-"+id).removeEventListener(EVENT_RELEASE, upDrag, false);
  document.getElementById("bigdragger-"+id).removeEventListener(EVENT_MOVE, moveDrag, false);
}

lightSlider.prototype.enableSlider = function(id){
  document.getElementById("bigdragger-"+id).addEventListener(EVENT_START, startDrag, false);
  document.getElementById("bigdragger-"+id).addEventListener(EVENT_RELEASE, upDrag, false);
  document.getElementById("bigdragger-"+id).addEventListener(EVENT_MOVE, moveDrag, false);
}

var down = false;
lightSlider.prototype.setupSlider = function(object, id, component){
  var newNode = document.createElement('div');
  newNode.innerHTML = '<div class="range-slider" id="range-slider-'+id+'"><div class="big-dragger" id="bigdragger-'+id+'"><div class="little-dragger" id="littledragger-'+id+'"></div></div></div>';
  object.appendChild(newNode);
  down = false;
  document.getElementById("bigdragger-"+id).addEventListener(EVENT_START, startDrag);
  document.getElementById("bigdragger-"+id).addEventListener(EVENT_RELEASE, upDrag);
  document.getElementById("bigdragger-"+id).addEventListener(EVENT_MOVE, moveDrag);
}

function moveDrag(event){
  event.preventDefault();
  updateDragger(event, event.target);
}

function startDrag(event){
  if( isMobile.iOS() ){ disableScroll();}
  
  down = true; event.preventDefault();
  var id = event.target.id; id = id.substring(id.indexOf('-')+1, id.length); 
  updateDragger(event, event.target);
}

function upDrag(event){
  down = false; event.preventDefault();
  var id = event.target.id; id = id.substring(id.indexOf('-')+1, id.length);   
  var rangeWidth = document.getElementById("range-slider-"+id).offsetWidth;
  var leftLimite = - (document.getElementById("bigdragger-"+id).offsetWidth*.5);
  var rigthLimite = rangeWidth - Math.abs(leftLimite);
  var value = getSliderPosition(document.getElementById("bigdragger-"+id), leftLimite, rigthLimite);
  publishBrightness('brightness', value, id, channel);
  if( isMobile.iOS() ){ enableScroll();}
}

function updateDragger(e , target) {
  var touch= null;
  if( isMobile.iOS() ){ disableScroll();}
  var name = target.id;
  name = name.substring(name.indexOf('-')+1, name.length);
  if(down !== true){ return; }
  var original = e;
  
  var rangeWidth = document.getElementById("range-slider-"+name).offsetWidth;
  var rangeLeft = document.getElementById("bigdragger-"+name).offsetWidth*.5;
  var draggerWidth = document.getElementById("bigdragger-"+name).offsetWidth;
  var leftLimite = - (document.getElementById("bigdragger-"+name).offsetWidth*.5);
  var rigthLimite = rangeWidth - Math.abs(leftLimite);
  var newV = 0;
  if (original.pageX && original.pageY) {
    touch = original;
  } else if (original.changedTouches) {
    touch = original.changedTouches[0];
  } else {  return; }
  var left = touch.pageX - document.getElementById("range-slider-"+name).offsetLeft - (draggerWidth*.5);
  if(left < leftLimite){
    left = leftLimite;
  }else if(left > rigthLimite){
    left = rigthLimite;
  }
  left = Math.round(left); 
  document.getElementById("bigdragger-"+name).style.left = left +'px';
  value = Math.round((((touch.pageX - rangeLeft) / parseInt(rangeWidth)) * 100));
}

lightSlider.prototype.setSliderPosition = function(dragger, leftLimite, rigthLimite, value){
  var position = range(value, minimum, maximum, leftLimite, rigthLimite);
  //dragger.css({left: position+'px'});
  dragger.style.left = position +'px';
}

lightSlider.prototype.getSliderPosition = function(dragger, leftLimite, rigthLimite, min, max){
  var position = parseFloat(dragger.offsetLeft).toFixed(1);
  var draggegrW = dragger.offsetWidth.toFixed(2);
  var newV = 0;
  if(min !== null && max !== null){
    newV = range(position, leftLimite, rigthLimite, min, max).toFixed(1);
  }else{
    newV = range(position, leftLimite, rigthLimite, minimum, maximum).toFixed(1);
  }
  return newV;
}

function getSliderPosition(dragger, leftLimite, rigthLimite){
  var position = parseFloat(dragger.offsetLeft).toFixed(1);
  var draggegrW = dragger.offsetWidth.toFixed(2);
  var newV = range(position, leftLimite, rigthLimite, minimum, maximum).toFixed(1);
  return parseFloat(newV);
}
function range(value, refMin, refMax, newMin, newMax) {
  return (((value - refMin) * (newMax - newMin)) / (refMax - refMin)) + newMin;
}

/////////////////////////////// end slider ///////////////////////////////